#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TSearchSegmentsDbRequest {
        struct TRequestParams {
            TSegmentId LastSegmentId = 0;
            ui64 Limit = 1000;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");

            DECLARE $lastSegmentId AS Uint64;
            DECLARE $limit AS Uint64;

            SELECT
                *
            FROM {segments_table}
            WHERE id > $lastSegmentId
            ORDER BY id
            LIMIT $limit;
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{segments_table}", YDB_PATHS.GetSegmentsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            return paramsBuilder
                .AddParam("$lastSegmentId").Uint64(params.LastSegmentId).Build()
                .AddParam("$limit").Uint64(params.Limit).Build()
                .Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteSearchSegmentsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId lastSegmentId, ui64 limit);
    TSegments SearchSegments(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId lastSegmentId, ui64 limit);

    TSegments ParseSearchSegmentsResult(const NYdb::NTable::TDataQueryResult& result);
}
