#include "search_users_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>
#include <crypta/siberia/bin/core/lib/ydb/parse_utils/parse_utils.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteSearchUsersDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TUserId lastUserId, ui64 limit) {
    return ExecuteYdbDynamicQuery<TSearchUsersDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.LastUserId = lastUserId, .Limit = limit});
}

TUsersResponse NSiberia::SearchUsers(TYdbClient& ydbClient, TUserSetId userSetId, TUserId lastUserId, ui64 limit) {
    const auto result = WaitFor(ExecuteSearchUsersDbRequest(ydbClient, userSetId, lastUserId, limit)).ValueOrThrow();
    ThrowOnError(result);
    return NYdbParseUtils::ParseUsers(result);
}
