#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/data/proto/user.pb.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>
#include <crypta/siberia/bin/core/proto/users_response.pb.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TSearchUsersDbRequest {
        struct TRequestParams {
            TUserId LastUserId = 0;
            ui64 Limit = 1000;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");
            PRAGMA SimpleColumns = '1';

            DECLARE $lastUserId AS Uint64;
            DECLARE $limit AS Uint64;

            $usersToList = (
                SELECT
                    *
                FROM {users_table}
                WHERE id > $lastUserId
                ORDER BY id LIMIT $limit
            );

            $usersSegments = (
                SELECT
                    users_segment_ids.user_id AS user_id,
                    LIST(AsStruct(segments.title AS title, segments.status AS status, segments.rule AS rule, segments.id AS id, segments.size AS size, segments.creation_ts AS creation_ts)) AS segments
                FROM (
                    SELECT
                        user_segments.*
                    FROM $usersToList AS users_to_list
                    JOIN {user_segments_table} AS user_segments
                    ON users_to_list.id == user_segments.user_id
                ) AS users_segment_ids
                JOIN {segments_table} AS segments
                ON users_segment_ids.segment_id == segments.id
                GROUP BY users_segment_ids.user_id
            );

            $usersAttributes = (
                SELECT
                    user_id,
                    ToDict(LIST(attributes)) as attributes
                FROM (
                    SELECT
                        user_id,
                        AsTuple(attribute_key, LIST(AsStruct(attribute_value AS attribute_value, ts AS ts))) as attributes
                    FROM (
                        SELECT
                            user_attributes.*
                        FROM $usersToList as users_to_list
                        JOIN {user_attributes_table} AS user_attributes
                        ON users_to_list.id == user_attributes.user_id
                    )
                    GROUP BY user_id, attribute_key
                )
                GROUP BY user_id
            );

            SELECT
                attributed_users.*,
                users_segments.segments AS segments
            FROM (
                SELECT
                    users_to_list.*,
                    users_attributes.attributes AS attributes
                FROM $usersToList AS users_to_list
                LEFT JOIN $usersAttributes AS users_attributes
                ON users_to_list.id == users_attributes.user_id
            ) AS attributed_users
            LEFT JOIN $usersSegments as users_segments
            ON attributed_users.id == users_segments.user_id
            ORDER BY id;
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{users_table}", YDB_PATHS.GetUsersTable());
            SubstGlobal(query, "{user_attributes_table}", YDB_PATHS.GetUserAttributesTable());
            SubstGlobal(query, "{user_segments_table}", YDB_PATHS.GetUserSegmentsTable());
            SubstGlobal(query, "{segments_table}", YDB_PATHS.GetSegmentsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            return paramsBuilder
                .AddParam("$lastUserId").Uint64(params.LastUserId).Build()
                .AddParam("$limit").Uint64(params.Limit).Build()
                .Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteSearchUsersDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TUserId lastUserId, ui64 limit);
    TUsersResponse SearchUsers(TYdbClient& ydbClient, TUserSetId userSetId, TUserId lastUserId, ui64 limit);
}
