import functools
import logging

import nirvana.job_context as nv

from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.siberia.bin.custom_audience.apps_clustering.lib import (
    apps,
    clusters,
    user_clusters,
)
from crypta.siberia.bin.custom_audience.apps_clustering.lib.utils import utils

logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stderr_logger(logging.getLogger(), level=logging.INFO)
    logger.info('Apps clustering')

    context = nv.context()
    parameters = context.parameters
    outputs = context.get_outputs()
    result_output = outputs.get('result')

    yt_client = yt_helpers.get_yt_client_from_nv_parameters(parameters)
    yql_client = yql_helpers.get_yql_client_from_nv_parameters(parameters)

    tasks_dict = {
        'get_apps_from_stores': functools.partial(
            utils.get_apps_from_stores,
            yt_client=yt_client,
            yql_client=yql_client,
            nv_params=parameters,
            output=result_output
        ),
        'update_clusters': functools.partial(clusters.update, yt_client=yt_client, yql_client=yql_client),
        'update_apps': functools.partial(apps.update, yt_client=yt_client),
        'update_user_clusters': functools.partial(user_clusters.update, yt_client=yt_client, yql_client=yql_client),
    }

    job_name = parameters.get('job_name')
    logger.info('Job name: {}'.format(job_name))

    if job_name in tasks_dict:
        tasks_dict[job_name]()
    else:
        logger.warn('Unknown job_name "{}"'.format(job_name))
        exit(1)


if __name__ == '__main__':
    main()
