import os

from crypta.siberia.bin.custom_audience.lib.python.clustering.config import *  # noqa
from crypta.siberia.bin.custom_audience.lib.python.clustering.config import (
    CUSTOM_AUDIENCE_DIR,
    PROFILES_INPUT_DATA_DIR,
)

# consts
MIN_DEVIDS_COUNT = 1000
NUMBER_OF_TOP_ELEMENTS_FOR_UPDATE_CLUSTERS = 10000
NEIGHBOURS_NUMBER = 10
ALLOWED_LARGEST_SEGMENT_SHARE_IN_CLUSTER = 0.5
UPPER_BOUND_DISTANCE_FOR_JOIN_MONSTERS = 0.047
ID_TYPES = ['idfa', 'gaid']

SERVICE_NAME = 'apps_clustering'

METRICS_LOWER_BOUNDS = {
    'old_clusterid_share': 0.44,
}
METRICS_UPPER_BOUNDS = {
    'distance': 0.141,
}

# common directories
PROFILES_APP_METRICS_DIR = os.path.join(PROFILES_INPUT_DATA_DIR, 'app-metrica')

APP_DATA_TABLE = '//home/rmp/production/app_data/latest/AppData'
DEVID_BY_APP_TABLE = os.path.join(PROFILES_APP_METRICS_DIR, 'devid_by_app')

# apps clustering
APPS_CLUSTERING_DIR = os.path.join(CUSTOM_AUDIENCE_DIR, 'apps_clustering')
CENTROIDS_TABLE = os.path.join(APPS_CLUSTERING_DIR, 'centroids')
CLUSTERING_TABLE = os.path.join(APPS_CLUSTERING_DIR, 'apps')
APP_DICT_TABLE = os.path.join(APPS_CLUSTERING_DIR, 'app_dict')
DAILY_CLUSTERING_DIR = os.path.join(APPS_CLUSTERING_DIR, 'daily_apps')
MONTHLY_CLUSTERING_DIR = os.path.join(APPS_CLUSTERING_DIR, 'monthly_apps')

# stages
CLUSTERING_UPDATE_STAGES_DIR = os.path.join(APPS_CLUSTERING_DIR, 'clustering_update_stages')
APPS_UPDATE_STAGES_DIR = os.path.join(APPS_CLUSTERING_DIR, 'apps_update_stages')

# dssm lal model
DSSM_LAL_MODEL_DIR = os.path.join(APPS_CLUSTERING_DIR, 'lal_model')
DSSM_LAL_MODEL_APPLIER_FILE = os.path.join(DSSM_LAL_MODEL_DIR, 'dssm_model.applier')
DSSM_LAL_MODEL_SEGMENT_DICT_FILE = os.path.join(DSSM_LAL_MODEL_DIR, 'segments_dict.json')

# datalens
DATALENS_DIR = os.path.join(APPS_CLUSTERING_DIR, 'datalens')
DATALENS_METRICS_TABLE = os.path.join(DATALENS_DIR, 'metrics')

# users table
CRYPTAID_CLUSTERID_DIR = os.path.join(APPS_CLUSTERING_DIR, 'cryptaid_clusterid')
