from crypta.lib.python.yt import schema_utils
from crypta.siberia.bin.custom_audience.apps_clustering.lib.utils import fields


def get_segments_vectors_with_info_schema():
    return {
        fields.name: 'string',
        fields.id: 'uint64',
        fields.id_type: 'string',
        fields.md5_hash: 'uint64',
        fields.vector: 'any',
        fields.users_count: 'uint64',
        fields.description: 'string',
    }


centroids_schema = [
    {
        'name': fields.name,
        'type': 'string',
    },
    {
        'name': fields.id,
        'type': 'uint64',
    },
    {
        'name': fields.id_type,
        'type': 'string',
    },
    {
        'name': fields.vector,
        'type': 'any',
    },
    {
        'name': fields.cluster_id,
        'type': 'uint32',
    },
    {
        'name': fields.users_count,
        'type': 'uint64',
    },
    {
        'name': fields.simlink,
        'type': 'uint64',
    },
    {
        'name': fields.neighbors,
        'type': 'any',
        'type_v3': {'type_name': 'optional', 'item': {'type_name': 'list', 'item': 'string'}},
    },
]


def get_centroids_schema():
    return schema_utils.get_strict_schema(centroids_schema)


def get_clustering_schema():
    return {
        fields.name: 'string',
        fields.id: 'uint64',
        fields.id_type: 'string',
        fields.md5_hash: 'uint64',
        fields.vector: 'any',
        fields.cluster_id: 'uint32',
        fields.users_count: 'uint64',
        fields.description: 'string',
    }
