import datetime

from crypta.lib.python import time_utils
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.schema_utils import proto
from crypta.siberia.bin.custom_audience.bs_apps_cluster_mapping.proto import state_pb2


def get_state_schema():
    return proto.get_schema_from_proto(state_pb2.TState, key_columns=['app_id'])


def run(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    with yt_client.Transaction() as tx:
        if not yt_client.exists(config.State):
            yt_helpers.create_empty_table(
                yt_client=yt_client,
                path=config.State,
                schema=get_state_schema(),
            )

        update_timestamp = time_utils.get_current_time()
        ttl_threshold = update_timestamp - int(datetime.timedelta(days=config.TtlDays).total_seconds())

        yql_helpers.run_query(
            query_template="/query/update_state.yql",
            yt_config=config.Yt,
            query_params={
                "apps": config.Apps,
                "state": config.State,
                "ttl_threshold": ttl_threshold,
                "update_timestamp": update_timestamp,
            },
            logger=logger,
            tx=tx,
        )
