from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import (
    tm_utils,
    yt_helpers,
)
from crypta.lib.python.yt.schema_utils import proto
from crypta.siberia.bin.custom_audience.suggester.bin.service.lib.proto import app_pb2


def get_output_schema():
    return proto.get_schema_from_proto(app_pb2.TApp, key_columns=['BundleId', 'PlatformId'])


def run(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    with yt_client.Transaction() as tx:
        if not yt_client.exists(config.OutputPath):
            yt_helpers.create_empty_table(
                yt_client=yt_client,
                path=config.OutputPath,
                schema=get_output_schema(),
            )

        yql_helpers.run_query(
            query_template="/query/build_suggest.yql",
            yt_config=config.Yt,
            query_params={
                "rmp_apps_path": config.RmpAppsPath,
                "apps_clustering_path": config.AppsClusteringPath,
                "output_path": config.OutputPath,
            },
            logger=logger,
            tx=tx,
        )

    if config.AdditionalYtClusters:
        tm_client = tm_utils.get_client(config.Yt.Token)

        for cluster in config.AdditionalYtClusters:
            dst_client = yt_helpers.get_yt_client(cluster)

            tm_utils.move_or_transfer_table(
                src_client=yt_client,
                src_path=config.OutputPath,
                dst_client=dst_client,
                dst_path=config.OutputPath,
                force=True,
                tm_client=tm_client,
            )
