#include "build_ca_mapper.h"

#include <crypta/lib/native/proto_serializer/proto_serializer.h>
#include <crypta/siberia/bin/custom_audience/common/rule/filter.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia::NCustomAudience;
using namespace NCrypta::NSiberia::NCustomAudience::NCaBuilder;

TBuildCaMapper::TBuildCaMapper(size_t filterThreshold, const TVector<TCaParent>& parents)
    : FilterThreshold(filterThreshold)
{
    for (const auto& parent: parents) {
        Parents.emplace_back(parent, 0);
    }
}

void TBuildCaMapper::Do(TReader* reader, TWriter* writer) {
    TCaBinding binding;

    for (; reader->IsValid(); reader->Next()) {
        const auto& userData = reader->GetRow();

        for (auto it = Parents.begin(); it != Parents.end();) {
            auto& [parent, count] = *it;

            if (NFilter::Filter(userData, parent.EncodedRule)) {
                binding.SetCaParentId(parent.Id);
                binding.SetCryptaId(FromString<ui64>(userData.GetCryptaID()));
                writer->AddRow(binding);
                count++;

                if (count >= FilterThreshold) {
                    it = Parents.erase(it);
                    continue;
                }
            }
            ++it;
        }
    }
}

REGISTER_MAPPER(TBuildCaMapper);
