#pragma once

#include "ca_parent.h"

#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/siberia/bin/custom_audience/ca_builder/proto/ca_binding.pb.h>

#include <mapreduce/yt/interface/client.h>

#include <util/generic/list.h>

namespace NCrypta::NSiberia::NCustomAudience::NCaBuilder {
    class TBuildCaMapper: public NYT::IMapper<NYT::TTableReader<NLab::TUserData>, NYT::TTableWriter<TCaBinding>> {
        public:
            TBuildCaMapper() = default;
            explicit TBuildCaMapper(size_t filterThreshold, const TVector<TCaParent>& parents);

            void Do(TReader* reader, TWriter* writer) override;

            Y_SAVELOAD_JOB(FilterThreshold, Parents);

        private:
            size_t FilterThreshold = 0;
            TList<std::pair<TCaParent, size_t>> Parents;
        };
}
