#include "decrease_size_reducer.h"

using namespace NCrypta::NSiberia::NCustomAudience::NCaBuilder;

TDecreaseSizeReducer::TDecreaseSizeReducer(size_t filterThreshold)
    : Threshold(filterThreshold)
{}

void TDecreaseSizeReducer::Do(TReader* reader, TWriter* writer) {
    for (size_t count = 0; reader->IsValid() && count < Threshold; reader->Next(), ++count) {
        writer->AddRow(reader->MoveRow());
    }
}

REGISTER_REDUCER(TDecreaseSizeReducer);
