#include "filter_ca_parents_mapper.h"

using namespace NCrypta;
using namespace NCrypta::NSiberia::NCustomAudience::NCaBuilder;

void TFilterCaParentsMapper::Do(TReader* reader, TWriter* writer) {
    for (; reader->IsValid(); reader->Next()) {
        const auto& row = reader->GetRow();
        const auto& parent = row.GetValue().GetMeta().GetParent();

        if (parent.GetType() == NLookalike::TLalParent::CUSTOM_AUDIENCE) {
            writer->AddRow(parent);
        }
    }
}

REGISTER_MAPPER(TFilterCaParentsMapper);
