#include "encoded_ca_rule.h"

#include <crypta/lib/proto/user_data/user_data.pb.h>

using namespace NCrypta::NSiberia::NCustomAudience;
using namespace NLab::NEncodedUserData;

namespace {
    template<typename TResult, typename TProbobufField>
    void FillHashSet(TResult& result, const TProbobufField& field) {
        result.insert(field.begin(), field.end());
    }
}

TEncodedCaRule::TEncodedCaRule(const TCaRule& rule, const TTokenToIdDict& wordDict, const TTokenToIdDict& hostDict, const TTokenToIdDict& appDict)
    : OriginalRule(rule)
{
    FillHashSet(Ages, rule.GetAges());
    FillHashSet(Devices, rule.GetDevices());
    FillHashSet(Regions, rule.GetRegions());
    FillHashSet(Incomes, rule.GetIncomes());
    FillHashSet(Countries, rule.GetCountries());
    FillHashSet(Cities, rule.GetCities());

    FillIds(Words, rule.GetWords(), wordDict);
    FillIds(Hosts, rule.GetHosts(), hostDict);
    FillIds(Apps, rule.GetApps(), appDict);
    FillIds(AffinitiveSites, rule.GetAffinitiveSites(), hostDict);
    FillIds(TopCommonSites, rule.GetTopCommonSites(), hostDict);
}

void TEncodedCaRule::FillIds(THashSet<ui32>& ids, const ::google::protobuf::RepeatedPtrField<TString>& tokens, const TTokenToIdDict& dict) {
    ids.reserve(tokens.size());

    for (const auto& token : tokens) {
        const auto iter = dict.find(token);
        if (iter != dict.end()) {
            ids.insert(iter->second);
        } else {
            UnknownItemsFound = true;
        }
    }
}

bool TEncodedCaRule::IsKernelEmpty() const {
    return OriginalRule.GetSegments().empty() && Words.empty() && Hosts.empty() && Apps.empty() && AffinitiveSites.empty() && TopCommonSites.empty();
}

bool TEncodedCaRule::HasUnknownItems() const {
    return UnknownItemsFound;
}
