#pragma once

#include <crypta/lab/lib/native/encoded_user_data.h>
#include <crypta/siberia/bin/custom_audience/common/proto/ca_rule.pb.h>

#include <contrib/libs/protobuf/src/google/protobuf/messagext.h>

#include <util/generic/set.h>
#include <util/generic/hash_set.h>
#include <util/ysaveload.h>

namespace NCrypta::NSiberia::NCustomAudience {
    class TEncodedCaRule {
    public:
        TEncodedCaRule(const TCaRule& rule, const NLab::NEncodedUserData::TTokenToIdDict& wordDict, const NLab::NEncodedUserData::TTokenToIdDict& hostDict, const NLab::NEncodedUserData::TTokenToIdDict& appDict);
        TEncodedCaRule() = default;

        bool IsKernelEmpty() const;
        bool HasUnknownItems() const;

        const TCaRule OriginalRule;
        THashSet<ui32> Words;
        THashSet<ui32> Hosts;
        THashSet<ui32> Apps;
        THashSet<ui32> AffinitiveSites;
        THashSet<ui32> TopCommonSites;

        THashSet<int> Ages;
        THashSet<int> Devices;
        THashSet<i64> Regions;
        THashSet<int> Incomes;
        THashSet<int> Countries;
        THashSet<int> Cities;

        Y_SAVELOAD_DEFINE((NProtoBuf::Message&)OriginalRule, Words, Hosts, Apps, AffinitiveSites, TopCommonSites, Ages, Devices, Regions, Incomes, Cities, UnknownItemsFound);

    private:
        void FillIds(THashSet<ui32>& ids, const ::google::protobuf::RepeatedPtrField<TString>& tokens, const NLab::NEncodedUserData::TTokenToIdDict& dict);

        bool UnknownItemsFound = false;
    };
}
