#pragma once

#include <crypta/lab/lib/native/encoded_user_data.h>
#include <crypta/siberia/bin/custom_audience/common/proto/extended_ca_rule.pb.h>

#include <util/generic/hash_set.h>
#include <util/generic/maybe.h>
#include <util/generic/vector.h>

namespace NCrypta::NSiberia::NCustomAudience {
    class TEncodedExtendedCaRule {
    public:
        class TPhrase {
        public:
            TPhrase(const TVector<ui32>& words, bool hasUnknownWords);

            static TPhrase FromString(const TString& s, const NLab::NEncodedUserData::TTokenToIdDict& dict);

            TVector<ui32> Words;
            bool HasUnknownWords = false;
        };

        class TPhraseGroup {
        public:
            TPhraseGroup(const TVector<TPhrase>& phrases, bool negative);

            static TPhraseGroup FromProto(const TGroup& group, const NLab::NEncodedUserData::TTokenToIdDict& dict);

            TVector<TPhrase> Phrases;
            bool Negative;
        };

        class TTokenGroup {
        public:
            TTokenGroup(const TVector<ui32>& items, bool hasUnknownTokens, bool Negative);

            static TTokenGroup FromProto(const TGroup& group, const NLab::NEncodedUserData::TTokenToIdDict& dict);

            TVector<ui32> Items;
            bool HasUnknownTokens = false;
            bool Negative = false;
        };

        class TEncodedKernel {
        public:
            TEncodedKernel(
                const TKernel& kernel,
                const NLab::NEncodedUserData::TTokenToIdDict& wordDict,
                const NLab::NEncodedUserData::TTokenToIdDict& hostDict,
                const NLab::NEncodedUserData::TTokenToIdDict& appDict
            );

            bool AggregateByOr = false;
            TVector<TPhraseGroup> Phrases;
            TVector<TTokenGroup> Hosts;
            TVector<TTokenGroup> Apps;
        };

        TEncodedExtendedCaRule(
            const TExtendedCaRule& rule,
            const NLab::NEncodedUserData::TTokenToIdDict& wordDict,
            const NLab::NEncodedUserData::TTokenToIdDict& hostDict,
            const NLab::NEncodedUserData::TTokenToIdDict& appDict
        );

        const TExtendedCaRule OriginalRule;

        THashSet<int> Ages;
        THashSet<int> Incomes;
        THashSet<i64> Regions;
        THashSet<int> Countries;
        THashSet<int> Devices;

        TMaybe<TEncodedKernel> Kernel;
    };
}
