#pragma once

#include "encoded_ca_rule.h"
#include "encoded_extended_ca_rule.h"

#include <crypta/lib/proto/user_data/native/segment.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/siberia/bin/custom_audience/common/proto/ca_rule.pb.h>
#include <crypta/siberia/bin/custom_audience/common/proto/extended_ca_rule.pb.h>

#include <util/generic/hash_set.h>

namespace NCrypta::NSiberia::NCustomAudience::NFilter {
    bool Filter(const NLab::TUserData& userData, const TEncodedCaRule& rule);

    bool FilterKernel(const NLab::TUserData& userData, const TEncodedCaRule& rule);
    bool FilterAttributes(const NLab::TUserData& userData, const TEncodedCaRule& rule);
    bool FilterSegments(const NLab::TUserData& userData, const ::google::protobuf::RepeatedPtrField<NLab::TSegment>& ruleSegments);

    bool HasTokens(const ::google::protobuf::RepeatedField<ui32>& userDataTokenIdsProto, const THashSet<ui32>& ruleTokenIds);
    bool HasTokens(const ::google::protobuf::RepeatedPtrField<NLab::TWeightedTokenEncoded>& userDataTokenIdsProto, const THashSet<ui32>& ruleTokenIds);

    bool Filter(const NLab::TUserData& userData, const TEncodedExtendedCaRule& rule);

    bool FilterAttributes(const NLab::TUserData& userData, const TEncodedExtendedCaRule& rule);
    bool FilterKernel(const NLab::TUserData& userData, const TEncodedExtendedCaRule& rule);

    bool HasPhrase(const THashSet<ui32>& words, const TEncodedExtendedCaRule::TPhrase& phrase);
    bool SatisfyPhraseGroup(const THashSet<ui32>& words, const TEncodedExtendedCaRule::TPhraseGroup& group);
    bool SatisfyPhraseGroups(const ::google::protobuf::RepeatedField<ui32>& userDataTokenIdsProto, const TVector<TEncodedExtendedCaRule::TPhraseGroup>& groups);

    bool SatisfyTokenGroup(const THashSet<ui32>& tokens, const TEncodedExtendedCaRule::TTokenGroup& group);
    bool SatisfyTokenGroups(const ::google::protobuf::RepeatedField<ui32>& userDataTokenIdsProto, const TVector<TEncodedExtendedCaRule::TTokenGroup>& groups);
}
