#pragma once

#include <crypta/lab/lib/native/encoded_user_data.h>
#include <crypta/lib/native/range/packs.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>

#include <util/generic/vector.h>

namespace NCrypta::NSiberia::NCustomAudience {
    using TUserDataIter = TVector<NLab::TUserData>::const_iterator;
    using TPacksVector = TVector<TIterRange<TUserDataIter>>;

    struct TTokenDicts {
        void Reserve(size_t size) {
            Dict.reserve(size);
            ReversedDict.reserve(size);
        }

        NLab::NEncodedUserData::TIdToWeightedTokenDict Dict;
        NLab::NEncodedUserData::TTokenToIdDict ReversedDict;
    };

    struct TDicts {
        TTokenDicts WordDicts;
        TTokenDicts HostDicts;
        TTokenDicts AppDicts;
    };
}
