#pragma once

#include <crypta/lib/native/grpc/async_client/async_client.h>
#include <crypta/siberia/bin/custom_audience/fast/grpc/custom_audience_service.grpc.pb.h>

namespace NCrypta::NSiberia::NCustomAudience {
    class TCaAsyncClient : public NGrpc::TAsyncGrpcClient<TCustomAudienceService> {
        using TBase = TAsyncGrpcClient<TCustomAudienceService>;
    public:
        TCaAsyncClient(const NGrpc::TAsyncClientConfig& clientConfig)
            : TBase(clientConfig)
        {}

        GRPC_ASYNC_METHOD(GetStats, TCaRule, NLab::TUserDataStats)
        GRPC_ASYNC_METHOD(GetIds, TCaRule, TPlainIds)
        GRPC_ASYNC_METHOD(GetStatsByExtendedRule, TExtendedCaRule, NLab::TUserDataStats)
        GRPC_ASYNC_METHOD(Ping, google::protobuf::Empty, TPingResponse)
        GRPC_ASYNC_METHOD(Ready, google::protobuf::Empty, TPingResponse)
    };
}
