from google.protobuf import empty_pb2
import grpc

from crypta.siberia.bin.custom_audience.fast.grpc import (
    custom_audience_service_pb2_grpc,
)


class CustomAudienceClient(object):
    def __init__(self, host, port):
        self.channel = grpc.insecure_channel("{}:{}".format(host, port), options=[('grpc.max_receive_message_length', 100 * 1024 * 1024)])
        self.stub = custom_audience_service_pb2_grpc.TCustomAudienceServiceStub(self.channel)

    def __del__(self):
        self.channel.close()

    def get_stats(self, request):
        return self.stub.GetStats(request)

    def get_stats_by_extended_rule(self, request):
        return self.stub.GetStatsByExtendedRule(request)

    def get_ids(self, request):
        return self.stub.GetIds(request)

    def ping(self):
        return self.stub.Ping(empty_pb2.Empty())

    def ready(self):
        return self.stub.Ready(empty_pb2.Empty())
