#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/signal_waiter/signal_waiter.h>
#include <crypta/lib/native/stats/log/log_stats_sink.h>
#include <crypta/lib/native/stats/solomon/solomon_stats_sink.h>
#include <crypta/lib/native/stats/utils.h>
#include <crypta/lib/native/yaml/config/config.h>
#include <crypta/siberia/bin/custom_audience/fast/bin/service/lib/config/config.pb.h>
#include <crypta/siberia/bin/custom_audience/fast/bin/service/lib/custom_audience_server/custom_audience_server.h>
#include <crypta/siberia/bin/custom_audience/fast/bin/service/lib/utils/db.h>

#include <grpc++/server.h>
#include <grpc++/server_builder.h>
#include <grpc/grpc.h>
#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/common/config.h>

#include <util/generic/vector.h>
#include <util/string/cast.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia::NCustomAudience;
using namespace NLab;

int main(int argc, const char** argv) {
    TSignalWaiter stopSignalWaiter({SIGTERM, SIGINT});
    const auto& config = ParseYamlConfig<TConfig>(argc, argv);

    NCrypta::NLog::RegisterLogs(config.GetLogs());
    auto log = NLog::GetLog("main");

    TVector<THolder<IStatsSink>> sinks;
    sinks.emplace_back(MakeHolder<TSolomonStatsSink>(config.GetSolomon()));
    auto statsWriter = GetStatsWriter(std::move(sinks));

    const auto& statsSettings = GetStatsSettings(config.GetStats());

    TDb db;

    TCustomAudienceServer server(config.GetService(), db, statsSettings);

    log->info("Starting server...");
    server.Start();
    log->info("Started");

    log->info("Reading files...");
    db.Read(config.GetDb(), log);
    log->info("Finished");

    stopSignalWaiter.Wait();
    log->info("Shutting down");
    return 0;
}
