#pragma once

#include <crypta/siberia/bin/custom_audience/common/utils/types.h>
#include <crypta/siberia/bin/custom_audience/fast/bin/service/lib/utils/db.h>
#include <crypta/siberia/bin/custom_audience/fast/grpc/custom_audience_service.grpc.pb.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>

#include <contrib/libs/grpc/include/grpc++/server.h>
#include <contrib/libs/grpc/include/grpc++/server_builder.h>

#include <util/generic/ptr.h>

namespace NCrypta::NSiberia::NCustomAudience {
    class TCustomAudienceServer {
    public:
        TCustomAudienceServer(
            const TServiceConfig& config,
            const TDb& db,
            const TStats::TSettings& statsSettings
        );
        ~TCustomAudienceServer();

        void Start();

    private:
        const ui32 Port = 0;
        const size_t MaxReceiveMessageSize = 0;
        THolder<TCustomAudienceService::Service> Service;
        std::unique_ptr<grpc::Server> Server;
        NLog::TLogPtr Log;
        const TStats::TSettings& StatsSettings;
    };
}
