#pragma once

#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/proto/identifiers/id.pb.h>
#include <crypta/siberia/bin/custom_audience/fast/bin/service/lib/utils/db.h>
#include <crypta/siberia/bin/custom_audience/fast/grpc/custom_audience_service.grpc.pb.h>
#include <crypta/siberia/bin/custom_audience/common/utils/types.h>

#include <library/cpp/threading/local_executor/local_executor.h>

namespace NCrypta::NSiberia::NCustomAudience {
    class TCustomAudienceServiceImpl: public TCustomAudienceService::Service {
    public:
        TCustomAudienceServiceImpl(
            size_t threadCount,
            const TDb& db,
            size_t describeThreshold,
            const TStats::TSettings& statsSettings
        );

    private:
        grpc::Status GetStatsBase(const TCaRule* request, NLab::TUserDataStats* response);

        grpc::Status GetStats(grpc::ServerContext* context, const TCaRule* request, NLab::TUserDataStats* response) override;
        grpc::Status GetStatsByExtendedRule(grpc::ServerContext* context, const TExtendedCaRule* request, NLab::TUserDataStats* response) override;
        grpc::Status GetIds(grpc::ServerContext* context, const TCaRule* request, TPlainIds* response) override;
        grpc::Status Ping(grpc::ServerContext* context, const google::protobuf::Empty* request, TPingResponse* response) override;
        grpc::Status Ready(grpc::ServerContext* context, const google::protobuf::Empty* request, TPingResponse* response) override;

        NPar::TLocalExecutor Executor;
        const TDb& Db;
        size_t DescribeThreshold = 0;

        NLog::TLogPtr Log;
        TStats& Stats;
    };
}
