#pragma once

#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/range/packs.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/siberia/bin/custom_audience/common/utils/types.h>
#include <crypta/siberia/bin/custom_audience/fast/bin/service/lib/config/config.pb.h>

#include <util/generic/vector.h>

namespace NCrypta::NSiberia::NCustomAudience {
    class TDb {
    public:
        void Read(const TDbConfig& config, NLog::TLogPtr log);
        const TPacksVector& GetPacks() const;
        const TDicts& GetDicts() const;
        bool IsReady() const;

    private:
        TAtomic Ready = 0;
        TPacksVector Packs;
        TVector<NLab::TUserData> UserDatas;
        TDicts Dicts;
    };
}