from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import (
    tm_utils,
    yt_helpers,
)


def filter_hosts(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    yt_client.create("map_node", config.Yt.TmpDir, recursive=True, ignore_existing=True)

    yql_helpers.run_query(
        query_template="/query/filter_hosts_query.yql",
        yt_config=config.Yt,
        query_params={
            "site_clusters": config.SiteClusters,
            "filtered_hosts_table": config.FilteredHostsTable,
        },
        logger=logger,
    )

    if config.AdditionalYtClusters:
        tm_client = tm_utils.get_client(config.Yt.Token)

        for cluster in config.AdditionalYtClusters:
            dst_client = yt_helpers.get_yt_client(cluster)

            tm_utils.move_or_transfer_table(
                src_client=yt_client,
                src_path=config.FilteredHostsTable,
                dst_client=dst_client,
                dst_path=config.FilteredHostsTable,
                force=True,
                tm_client=tm_client
            )
