import os

# consts
DAY_OF_UPDATE_CLUSTERS = 15
UPDATE_CLUSTERS_PERIOD_MONTHS = 1
MIN_CLUSTER_SIZE = 5
DAILY_CLUSTERING_TO_KEEP = 7
MONTHLY_CLUSTERING_TO_KEEP = 12
DAYS_TO_KEEP_USERID_CLUSTERID = 14

YT_PROXY = 'hahn'
YT_POOL = 'crypta_cdp'

CRYPTA_ML_JUGGLER_HOST = 'crypta.ml.production'

CRYPTA_YT_WORKING_DIR = '//home/crypta/production' if os.environ.get('CRYPTA_ENVIRONMENT') == 'production' else '//home/crypta/testing'

# common directories
COMMON_TMP_DIR = '//tmp'
COMMON_YQL_TMP_DIR = os.path.join(COMMON_TMP_DIR, 'yql')
SIBERIA_DIR = os.path.join(CRYPTA_YT_WORKING_DIR, 'siberia')
CUSTOM_AUDIENCE_DIR = os.path.join(SIBERIA_DIR, 'custom_audience')
PROFILES_YT_DIR = os.path.join(CRYPTA_YT_WORKING_DIR, 'profiles')
PROFILES_INPUT_DATA_DIR = os.path.join(PROFILES_YT_DIR, 'input-data')

# matching
ID_TO_CRYPTA_ID_TABLE = os.path.join(SIBERIA_DIR, 'id_to_crypta_id')
