import argparse
import functools
import logging

from crypta.lib.python.logging import logging_helpers
from crypta.siberia.bin.custom_audience.sites_clustering.lib import (
    clusters,
    sites,
    user_clusters,
)

logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stderr_logger(logging.getLogger(), level=logging.INFO)
    logger.info('Sites Clustering')

    tasks_dict = {
        'update_clusters' : functools.partial(clusters.update),
        'update_sites' : functools.partial(sites.update),
        'update_user_clusters': functools.partial(user_clusters.update),
    }

    parser = argparse.ArgumentParser()
    parser.add_argument('job_name', type=str, help=' / '.join(tasks_dict.keys()))
    args = parser.parse_args()

    if args.job_name in tasks_dict:
        logger.info('Job name {} is started'.format(args.job_name))
        tasks_dict[args.job_name]()
        logger.info('Job name {} is successfully finished'.format(args.job_name))
    else:
        logger.warn('Unknown job_name "{}"'.format(args.job_name))
        exit(1)


if __name__ == '__main__':
    main()
