import logging

from crypta.profile.lib import date_helpers
from crypta.siberia.bin.custom_audience.lib.python.clustering import utils as clustering_utils
from crypta.siberia.bin.custom_audience.sites_clustering.lib.utils import (
    config,
    fields,
    utils,
)


logger = logging.getLogger(__name__)


def update():
    yt_client = clustering_utils.get_yt_client(config=config)
    yql_client = clustering_utils.get_yql_client(config=config)

    today = date_helpers.get_today_date_string()
    clusters_last_update_planned_date = yt_client.get_attribute(
        path=config.CENTROIDS_TABLE,
        attribute='last_update_planned_date',
        default='1970-01-01',
    )
    if date_helpers.get_date_from_past(today, months=config.UPDATE_CLUSTERS_PERIOD_MONTHS) >= clusters_last_update_planned_date:
        logger.info('Clusters centroids table was updated more than {} month'.format(config.UPDATE_CLUSTERS_PERIOD_MONTHS))
        return

    sites_clustering_generate_date = yt_client.get_attribute(
        path=config.CLUSTERING_TABLE,
        attribute='generate_date',
        default='1970-01-01',
    )
    if sites_clustering_generate_date == today:
        logger.info('sites clustering table is updated today')
        return

    for input_table in [
        config.METRICS_CRYPTA_ID_FLATTEN_HITS_TABLE,
        config.BAR_CRYPTA_ID_FLATTEN_HITS_TABLE,
        config.CRYPTA_ID_METRICA_BROWSER_VISITOR_COUNTER_TABLE,
    ]:
        if yt_client.get_attribute(input_table, 'generate_date') != today:
            logger.info('{} was not updated at {}'.format(input_table, today))
            return

    clustering_utils.update_stages_tables(
        yt_client=yt_client,
        yql_client=yql_client,
        prepare_for_describe=utils.prepare_for_describe,
        get_segments_vectors_with_info=utils.get_sites_vectors_with_info,
        stages_dir=config.SITES_UPDATE_STAGES_DIR,
        config=config,
        only_new_segments=True,
        update_model=False,
    )

    clustering_utils.apply_clustering(
        yt_client=yt_client,
        stages_dir=config.SITES_UPDATE_STAGES_DIR,
        config=config,
        fields=fields,
    )
