import os

from crypta.siberia.bin.custom_audience.lib.python.clustering.config import *  # noqa
from crypta.siberia.bin.custom_audience.lib.python.clustering.config import (
    CUSTOM_AUDIENCE_DIR,
    PROFILES_INPUT_DATA_DIR,
)

# consts
NUMBER_OF_TOP_ELEMENTS_FOR_UPDATE_CLUSTERS = 80000
NEIGHBOURS_NUMBER = 20
ALLOWED_LARGEST_SEGMENT_SHARE_IN_CLUSTER = 0.5
UPPER_BOUND_DISTANCE_FOR_JOIN_MONSTERS = 0.085

SERVICE_NAME = 'sites_clustering'

METRICS_LOWER_BOUNDS = {
    'old_clusterid_share': 0.55,
}
METRICS_UPPER_BOUNDS = {
    'distance': 0.255,
}

# common directories
PROFILES_METRICS_DIR = os.path.join(PROFILES_INPUT_DATA_DIR, 'metrics')
PROFILES_BAR_DIR = os.path.join(PROFILES_INPUT_DATA_DIR, 'bar')

# hits
METRICS_YANDEXUID_FLATTEN_HITS_TABLE = os.path.join(PROFILES_METRICS_DIR, 'yandexuid_flattened_hits')
BAR_YANDEXUID_FLATTEN_HITS_TABLE = os.path.join(PROFILES_BAR_DIR, 'yandexuid_flattened_hits')
METRICS_CRYPTA_ID_FLATTEN_HITS_TABLE = os.path.join(PROFILES_METRICS_DIR, 'crypta_id_flattened_hits')
BAR_CRYPTA_ID_FLATTEN_HITS_TABLE = os.path.join(PROFILES_BAR_DIR, 'crypta_id_flattened_hits')
CRYPTA_ID_METRICA_BROWSER_VISITOR_COUNTER_TABLE = os.path.join(PROFILES_INPUT_DATA_DIR, 'crypta_id_metrica_browser_visitor_counter')

# matching
MATCHING_YANDEXUID_CRYPTA_ID_TABLE = '//home/crypta/public/matching/by_id/yandexuid/crypta_id'

# sites clustering
SITES_CLUSTERING_DIR = os.path.join(CUSTOM_AUDIENCE_DIR, 'sites_clustering')
CENTROIDS_TABLE = os.path.join(SITES_CLUSTERING_DIR, 'centroids')
CLUSTERING_TABLE = os.path.join(SITES_CLUSTERING_DIR, 'sites')
SITE_DICT_TABLE = os.path.join(SITES_CLUSTERING_DIR, 'site_dict')
DAILY_CLUSTERING_DIR = os.path.join(SITES_CLUSTERING_DIR, 'daily_sites')
MONTHLY_CLUSTERING_DIR = os.path.join(SITES_CLUSTERING_DIR, 'monthly_sites')

# stages
CLUSTERING_UPDATE_STAGES_DIR = os.path.join(SITES_CLUSTERING_DIR, 'clustering_update_stages')
SITES_UPDATE_STAGES_DIR = os.path.join(SITES_CLUSTERING_DIR, 'sites_update_stages')

# dssm lal model
DSSM_LAL_MODEL_DIR = os.path.join(SITES_CLUSTERING_DIR, 'lal_model')
DSSM_LAL_MODEL_APPLIER_FILE = os.path.join(DSSM_LAL_MODEL_DIR, 'dssm_model.applier')
DSSM_LAL_MODEL_SEGMENT_DICT_FILE = os.path.join(DSSM_LAL_MODEL_DIR, 'segments_dict.json')

# datalens
DATALENS_DIR = os.path.join(SITES_CLUSTERING_DIR, 'datalens')
DATALENS_METRICS_TABLE = os.path.join(DATALENS_DIR, 'metrics')

# users table
YANDEXUID_CLUSTERID_DIR = os.path.join(SITES_CLUSTERING_DIR, 'yandexuid_clusterid')
CRYPTAID_CLUSTERID_DIR = os.path.join(SITES_CLUSTERING_DIR, 'cryptaid_clusterid')
