#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/signal_waiter/signal_waiter.h>
#include <crypta/lib/native/stats/log/log_stats_sink.h>
#include <crypta/lib/native/stats/solomon/solomon_stats_sink.h>
#include <crypta/lib/native/stats/utils.h>
#include <crypta/lib/native/yaml/config/config.h>
#include <crypta/siberia/bin/custom_audience/suggester/bin/service/lib/config/config.pb.h>
#include <crypta/siberia/bin/custom_audience/suggester/bin/service/lib/suggester_server/database.h>
#include <crypta/siberia/bin/custom_audience/suggester/bin/service/lib/suggester_server/suggester_server.h>

#include <grpc++/server.h>
#include <grpc++/server_builder.h>
#include <grpc/grpc.h>
#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/common/config.h>

#include <util/generic/vector.h>
#include <util/string/cast.h>
#include <util/system/backtrace.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia::NCustomAudience::NSuggester;
using namespace NLab;


int main(int argc, const char** argv) {
    auto stderrLog = NLog::GetLog();

    try {
        TSignalWaiter stopSignalWaiter({SIGTERM, SIGINT});
        const auto& config = ParseYamlConfig<TConfig>(argc, argv);

        NCrypta::NLog::RegisterLogs(config.GetLogs());
        auto log = NLog::GetLog("main");

        TVector<THolder<IStatsSink>> sinks;
        sinks.emplace_back(MakeHolder<TSolomonStatsSink>(config.GetSolomon()));
        auto statsWriter = GetStatsWriter(std::move(sinks));

        const auto& statsSettings = GetStatsSettings(config.GetStats());

        TDatabase database(config.GetDb(), statsSettings);
        TSuggesterServer server(config.GetService(), database, statsSettings);

        log->info("Starting server...");
        server.Start();
        log->info("Started");

        log->info("Starting database read...");
        database.Start();
        log->info("Started");

        stopSignalWaiter.Wait();
        log->info("Shutting down");
        return 0;
    } catch (...) {
        stderrLog->error("Exception: {}", CurrentExceptionMessage());
        stderrLog->error("Backtrace: {}", TBackTrace::FromCurrentException().PrintToString());
    }

}
