#pragma once

#include "database_state.h"

#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/periodic_task/periodic_task.h>
#include <crypta/lib/native/stats/stats.h>

#include <crypta/siberia/bin/custom_audience/suggester/bin/service/lib/config/config.pb.h>

#include <library/cpp/threading/hot_swap/hot_swap.h>

namespace NCrypta::NSiberia::NCustomAudience::NSuggester {
    class TDatabase : public TPeriodicTask {
    public:
        TDatabase(const TDbConfig& config, const TStats::TSettings& statsSettings);
        bool IsReady() const;
        TDatabaseStatePtr GetState() const;

    private:
        void Read();

        const TDbConfig& Config;
        NLog::TLogPtr Log;
        THotSwap<TDatabaseState> State;
        TStats& Stats;
    };
}
