#include "database_state.h"

#include <util/charset/utf8.h>

using namespace NCrypta::NSiberia::NCustomAudience::NSuggester;

TDatabaseState::TSegmentItem::TLangSpecificInfo::TLangSpecificInfo(TString name, TString description)
    : Name(std::move(name))
    , Description(std::move(description))
    , SearchString(ToLowerUTF8(Name + ". " + Description)) {
}

TDatabaseState::TDatabaseState(TSegments&& segments, THolder<THosts> hosts, TApps&& apps)
    : Segments(std::move(segments))
    , Hosts(std::move(hosts))
    , Apps(std::move(apps)) {
}

const TVector<TDatabaseState::TSegmentItem>& TDatabaseState::GetSegments() const {
    return Segments;
}

const TDatabaseState::TTrie& TDatabaseState::GetHostsTrie() const {
    return Hosts->Trie;
}

TMaybe<TString> TDatabaseState::GetHostById(ui64 id) const {
    const auto& it = Hosts->ById.find(id);
    return it == Hosts->ById.end() ? Nothing() : MakeMaybe(it->second);
}

TMaybe<TDatabaseState::TApps::TAppInfo> TDatabaseState::GetAppInfoById(const ui64 id) const {
    const auto& it = Apps.ById.find(id);
    return it == Apps.ById.end() ? Nothing() : MakeMaybe(*(it->second));
}

const TDatabaseState::TApps& TDatabaseState::GetApps() const {
    return Apps;
}
