#pragma once

#include "enum_utils.h"

#include <crypta/siberia/bin/custom_audience/suggester/grpc/suggester_service.pb.h>

#include <library/cpp/containers/comptrie/comptrie.h>

#include <util/generic/hash_set.h>
#include <util/generic/maybe.h>
#include <util/generic/ptr.h>
#include <util/generic/vector.h>

namespace NCrypta::NSiberia::NCustomAudience::NSuggester {
    class TDatabaseState : public TThrRefBase {
    public:
        struct TSegmentItem {
            struct TLangSpecificInfo {
                TString Name;
                TString Description;
                TString SearchString;

                TLangSpecificInfo(TString name, TString description);
                TLangSpecificInfo() = default;
            };

            ::google::protobuf::RepeatedPtrField<TExport> Exports;
            THashMap<TString, TLangSpecificInfo> LangInfo;
            TString Type;
            THashSet<NRawData::TExport::ECampaignType> CampaignTypes;
        };

        using THostData = std::pair<ui64, ui64>;
        using TTrie = TCompactTrie<char, THostData>;

        struct THosts {
            TTrie Trie;
            THashMap<ui64, TString> ById;
            TBufferStream TrieStream;
        };

        struct TApps {
            struct TAppInfo {
                NRawData::TApp Raw;

                TString NormalizedBundleId;
                THashMap<TString, TString> NormalizedTitles;
            };

            TVector<TAppInfo> SortedByCount;
            THashMap<ui64, const TAppInfo*> ById;
        };

        using TSegments = TVector<TSegmentItem>;

        TDatabaseState(TSegments&& segments, THolder<THosts> hosts, TApps&& apps);

        const TVector<TSegmentItem>& GetSegments() const;
        const TTrie& GetHostsTrie() const;
        const TApps& GetApps() const;
        TMaybe<TString> GetHostById(ui64 id) const;
        TMaybe<TApps::TAppInfo> GetAppInfoById(const ui64 id) const;

    private:
        TSegments Segments;
        THolder<THosts> Hosts;
        TApps Apps;
    };

    using TDatabaseStatePtr = TIntrusivePtr<TDatabaseState>;
}
