#pragma once

#include <crypta/siberia/bin/custom_audience/suggester/bin/service/lib/proto/segment.pb.h>

#include <util/generic/hash.h>

template <>
struct THash<NCrypta::NSiberia::NCustomAudience::NSuggester::NRawData::TExport::ECampaignType> {
    size_t operator()(const NCrypta::NSiberia::NCustomAudience::NSuggester::NRawData::TExport::ECampaignType& campaignType) const {
        return ComputeHash(static_cast<ui64>(campaignType));
    }
};

template <>
struct TEqualTo<NCrypta::NSiberia::NCustomAudience::NSuggester::NRawData::TExport::ECampaignType> {
    size_t operator()(
        const NCrypta::NSiberia::NCustomAudience::NSuggester::NRawData::TExport::ECampaignType& lhs,
        const NCrypta::NSiberia::NCustomAudience::NSuggester::NRawData::TExport::ECampaignType& rhs
    ) const {
        return static_cast<ui64>(lhs) == static_cast<ui64>(rhs);
    }
};
