#include "suggester_server.h"

#include "suggester_service_impl.h"

#include <crypta/lib/native/grpc/keepalive/keepalive.h>
#include <crypta/lib/native/grpc/logging/logging_interceptor_factory.h>
#include <crypta/lib/native/grpc/stats/stats_interceptor_factory.h>

#include <util/string/cast.h>

using namespace NCrypta::NSiberia::NCustomAudience::NSuggester;

TSuggesterServer::TSuggesterServer(
    const TServiceConfig& config,
    const TDatabase& database,
    const TStats::TSettings& statsSettings
)
    : Port(config.GetPort())
    , Service(MakeHolder<TSuggesterServiceImpl>(database, statsSettings))
    , Log(NLog::GetLog("suggester_server"))
    , StatsSettings(statsSettings)
{
}

void TSuggesterServer::Start() {
    const auto& hostPort = TString("0.0.0.0:") + ToString(Port);

    grpc::ServerBuilder builder;
    builder.AddListeningPort(hostPort, grpc::InsecureServerCredentials());
    builder.RegisterService(Service.Get());
    NCrypta::NGrpc::EnableServerKeepalive(builder);

    std::vector<std::unique_ptr<grpc::experimental::ServerInterceptorFactoryInterface>> creators;

    creators.push_back(std::make_unique<NCrypta::NGrpc::TLoggingInterceptorFactory>(
        [&](TString&& line){ Log->info(std::move(line)); },
        Log
    ));
    creators.push_back(std::make_unique<NCrypta::NGrpc::TStatsInterceptorFactory>(StatsSettings));

    builder.experimental().SetInterceptorCreators(std::move(creators));

    Server = builder.BuildAndStart();

    if (!Server) {
        ythrow yexception() << "Can't start server";
    }

    Log->info("TSuggesterServer is listening on {}", hostPort);
}

TSuggesterServer::~TSuggesterServer() {
    Log->info("Shutting down the server...");
    Server->Shutdown();
    Server->Wait();
    Log->info("Done");
}
