#pragma once

#include "database.h"

#include <crypta/siberia/bin/custom_audience/common/utils/types.h>
#include <crypta/siberia/bin/custom_audience/suggester/bin/service/lib/config/config.pb.h>
#include <crypta/siberia/bin/custom_audience/suggester/grpc/suggester_service.grpc.pb.h>

#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>

#include <contrib/libs/grpc/include/grpc++/server.h>
#include <contrib/libs/grpc/include/grpc++/server_builder.h>

#include <util/generic/ptr.h>

namespace NCrypta::NSiberia::NCustomAudience::NSuggester {
    class TSuggesterServer {
    public:
        TSuggesterServer(
            const TServiceConfig& config,
            const TDatabase& database,
            const TStats::TSettings& statsSettings
        );
        ~TSuggesterServer();

        void Start();

    private:
        const ui32 Port = 0;
        THolder<TSuggesterService::Service> Service;
        std::unique_ptr<grpc::Server> Server;
        NLog::TLogPtr Log;
        const TStats::TSettings& StatsSettings;
    };
}
