#pragma once

#include "database.h"

#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/siberia/bin/custom_audience/suggester/grpc/suggester_service.grpc.pb.h>


namespace NCrypta::NSiberia::NCustomAudience::NSuggester {
    class TSuggesterServiceImpl: public TSuggesterService::Service {
    public:
        TSuggesterServiceImpl(const TDatabase& db, const TStats::TSettings& statsSettings);

    private:
        grpc::Status Suggest(grpc::ServerContext* context, const TSuggestRequest* request, TSuggestResponse* response) override;
        grpc::Status Ping(grpc::ServerContext* context, const google::protobuf::Empty* request, TPingResponse* response) override;
        grpc::Status Ready(grpc::ServerContext* context, const google::protobuf::Empty* request, TPingResponse* response) override;
        grpc::Status GetHosts(grpc::ServerContext* context, const TGetHostsRequest* request, TGetHostsResponse* response) override;
        grpc::Status GetApps(grpc::ServerContext* context, const TGetAppsRequest* request, TGetAppsResponse* response) override;

        const TDatabase& Database;

        NLog::TLogPtr Log;
        TStats& Stats;
    };
}
