#!/bin/bash

data_dir="/root/data"
logs_dir="/root/logs"

mkdir -p "$logs_dir"
mkdir -p "$data_dir"

/root/crypta-templater \
    --input "/root/config/service_config.template.yaml" \
    --output "/root/config/service_config.yaml" \
    "environment_type=$CRYPTA_ENVIRONMENT" \
    "port=$GRPC_PORT" \
    "logs_dir=$logs_dir" \
    "host=$DEPLOY_POD_PERSISTENT_FQDN" \
    "dc=$DEPLOY_NODE_DC"

/root/crypta-templater \
    --input "/root/config/http_proxy_config.template.yaml" \
    --output "/root/config/http_proxy_config.yaml" \
    "environment_type=$CRYPTA_ENVIRONMENT" \
    "grpc_port=$GRPC_PORT" \
    "http_port=$HTTP_PORT"
