EXECTEST()

OWNER(
    g:crypta
    g:crypta-siberia
)

RUN(
    NAME service_production
    CWD ${ARCADIA_ROOT}/crypta/siberia/bin/custom_audience/suggester/docker/templates

    render_and_check_yaml
        --template service_config.template.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment_type": "production", "logs_dir": "/local/logs", "port": 80, "dc": "sas", "host": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME service_qa
    CWD ${ARCADIA_ROOT}/crypta/siberia/bin/custom_audience/suggester/docker/templates

    render_and_check_yaml
        --template service_config.template.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment_type": "qa", "logs_dir": "/tmp", "port": 1234, "solomon_schema": "http", "solomon_host": "localhost", "solomon_port": 2345, "hosts_table": "//dir/hosts", "segments_table": "//dir/segments", "apps_table": "//dir/apps", "dc": "sas", "host": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME proxy_production
    CWD ${ARCADIA_ROOT}/crypta/siberia/bin/custom_audience/suggester/docker/templates

    render_and_check_yaml
        --template http_proxy_config.template.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment_type": "production", "grpc_port": 80, "http_port": 81}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME proxy_qa
    CWD ${ARCADIA_ROOT}/crypta/siberia/bin/custom_audience/suggester/docker/templates

    render_and_check_yaml
        --template http_proxy_config.template.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment_type": "qa", "http_port": 1234, "grpc_port": 2345}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/siberia/bin/custom_audience/suggester/docker/templates/http_proxy_config.template.yaml
    arcadia/crypta/siberia/bin/custom_audience/suggester/docker/templates/service_config.template.yaml
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()
