EXECTEST()

OWNER(
    g:crypta
    g:crypta-siberia
)

RUN(
    NAME testing_config
    CWD ${ARCADIA_ROOT}/crypta/siberia/bin/describer/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "testing", "dc": "man", "topic": "crypta@test@siberia--describe-log"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME stable_config
    CWD ${ARCADIA_ROOT}/crypta/siberia/bin/describer/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "production", "dc": "sas", "topic": "crypta@prod@siberia--describe-log", "stats_update_threshold": 100000}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME testing_qa
    CWD ${ARCADIA_ROOT}/crypta/siberia/bin/describer/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "qa", "dc": "qa", "logbroker_server": "localhost", "logbroker_port": "20500", "topic": "lb-topic", "client_id": "lb-consumer", "client_tvm_id": "", "master_table_path": "//master/table/path", "yt_proxy_url": "master.yt.yandex.net", "proxy_role": "default", "log_dir": "/tmp", "use_secure_tvm": false, "tracked_back_references": ["foo"], "ydb_endpoint": "ydb_endpoint", "ydb_database": "ydb_database", "ydb_token_file": "ydb_token_file", "describing_batch_size": 100, "stats_update_threshold": 5000}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/siberia/bin/describer/bundle/templates/config.yaml
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()
