#include "processor_factory.h"

#include <crypta/siberia/bin/common/describing/proto/describe_cmd.pb.h>
#include <crypta/siberia/bin/describer/lib/processors/describe_ids_processor.h>
#include <crypta/siberia/bin/describer/lib/processors/describe_user_set_processor.h>

#include <library/cpp/protobuf/json/json2proto.h>

using namespace NCrypta::NEventProcessing;
using namespace NCrypta::NSiberia;
using namespace NCrypta::NSiberia::NDescriber;

TProcessorFactory::TProcessorFactory(
    TYdbClient& ydbClient,
    size_t describingBatchSize,
    size_t statsUpdateThreshold,
    size_t maxUserProcessedCount,
    TStats& stats
)
    : YdbClient(ydbClient)
    , DescribingBatchSize(describingBatchSize)
    , StatsUpdateThreshold(statsUpdateThreshold)
    , MaxUserProcessedCount(maxUserProcessedCount)
    , Stats(stats)
{}

IProcessorPtr TProcessorFactory::Create(const TStringBuf& commandString) const {
    const auto& command = NProtobufJson::Json2Proto<TDescribeCmd>(commandString, {.AllowUnknownFields=false, .CastRobust=true});
    const auto& commandType = command.GetCommandCase();
    const auto& commandTimestamp = TInstant::Seconds(command.GetTimestamp());

    if (commandType == TDescribeCmd::kDescribeIdsCmd) {
        return MakeHolder<TDescribeIdsProcessor>(command.GetDescribeIdsCmd(), commandTimestamp, YdbClient, DescribingBatchSize, StatsUpdateThreshold, Stats);
    } else if (commandType == TDescribeCmd::kDescribeUserSetCmd) {
        return MakeHolder<TDescribeUserSetProcessor>(command.GetDescribeUserSetCmd(), commandTimestamp, YdbClient, DescribingBatchSize, StatsUpdateThreshold, MaxUserProcessedCount, Stats);
    } else {
        return nullptr;
    }
}
