#pragma once

#include <crypta/lib/native/event_processing/processor_factory.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/ydb/ydb_client.h>

namespace NCrypta::NSiberia::NDescriber {
    class TProcessorFactory : public NEventProcessing::IProcessorFactory {
    public:
        TProcessorFactory(
            TYdbClient& ydbClient,
            size_t describingBatchSize,
            size_t statsUpdateThreshold,
            size_t maxUserProcessedCount,
            TStats& stats
        );

        NEventProcessing::IProcessorPtr Create(const TStringBuf& commandString) const override;

    private:
        TYdbClient& YdbClient;
        size_t DescribingBatchSize = 0;
        size_t StatsUpdateThreshold = 0;
        size_t MaxUserProcessedCount = 0;
        TStats& Stats;
    };
}
