#pragma once

#include "describe_processor.h"

#include "id_with_hash.h"

#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/ydb/types.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/describing/proto/describe_ids_cmd.pb.h>

#include <ydb/public/sdk/cpp/client/ydb_scheme/scheme.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>

namespace NCrypta::NSiberia::NDescriber {
    class TDescribeIdsProcessor : public TDescribeProcessor {
        using TBase = TDescribeProcessor;

    public:
        TDescribeIdsProcessor(
            TDescribeIdsCmd command,
            TInstant commandTimestamp,
            TYdbClient& ydbClient,
            size_t describingBatchSize,
            size_t statsUpdateThreshold,
            ::TStats& stats
        );

    private:
        bool ProcessCommand() override;

        TString AddMessagePrefix(TUserSetId userSetId, const TString& message) override;
        void NormalizeIds(TVector<TIdWithHash>& ordinaryIds, TVector<ui64>& cryptaIds);
        void DescribeNativeCryptaIds(const TVector<ui64>& cryptaIds, const TString& userDataTablePath);
        void DescribeOrdinaryIds(const TVector<TIdWithHash>& ordinaryIds, const TString& idToCryptaIdTablePath, const TString& userDataTablePath, size_t alreadyDescribedIdsCount);

        TDescribeIdsCmd Command;
    };
}
