#pragma once

#include "describe_processor.h"

#include <crypta/lib/native/stats/stats.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/describing/proto/describe_user_set_cmd.pb.h>

#include <ydb/public/sdk/cpp/client/ydb_scheme/scheme.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>

namespace NCrypta::NSiberia::NDescriber {
    class TDescribeUserSetProcessor : public TDescribeProcessor {
        using TBase = TDescribeProcessor;

    public:
        TDescribeUserSetProcessor(
            TDescribeUserSetCmd command,
            TInstant commandTimestamp,
            TYdbClient& ydbClient,
            size_t describingBatchSize,
            size_t statsUpdateThreshold,
            size_t maxUserProcessedCount,
            ::TStats& stats
        );

    private:
        bool ProcessCommand() override;

        TString AddMessagePrefix(TUserSetId userSetId, const TString& message) override;

        TDescribeUserSetCmd Command;
        size_t MaxUserProcessedCount = 0;
    };
}
