#include "indexes.h"

#include <util/generic/algorithm.h>

using namespace NCrypta::NSiberia::NDescriber;

TIndexes::TIndexes(size_t batchSize, size_t maxIndex)
    : BatchSize(batchSize)
    , MaxIndex(maxIndex)
    , StartIndex(0)
    , EndIndex(GetEndIndex(StartIndex))
    , NextEndIndex(GetEndIndex(EndIndex))
{}

void TIndexes::Shift() {
    StartIndex = EndIndex;
    EndIndex = NextEndIndex;
    NextEndIndex = GetEndIndex(EndIndex);
}

bool TIndexes::BatchExists() const {
    return StartIndex < MaxIndex;
}

bool TIndexes::NextBatchExists() const {
    return EndIndex < MaxIndex;
}

size_t TIndexes::GetEndIndex(size_t startIndex) const {
    return Min(startIndex + BatchSize, MaxIndex);
}
