#include "ydb_requests.h"

#include <crypta/lib/native/ydb/executer.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

NYdb::NTable::TAsyncDataQueryResult NDescriber::DescribeCryptaIds(TYdbClient& ydbClient, const TVector<ui64>& cryptaIds, size_t startIndex, size_t endIndex, const TString& userDataTablePath) {
    return ExecuteYdbDynamicQuery<TDescribeCryptaIdsDbRequest>(ydbClient, "", {.UserDataTablePath = userDataTablePath, .CryptaIds = cryptaIds, .StartIndex = startIndex, .EndIndex = endIndex}, NYdb::NTable::TTxSettings::StaleRO());
}

NYdb::NTable::TAsyncDataQueryResult NDescriber::DescribeCryptaIds(TYdbClient& ydbClient, const TVector<ui64>& cryptaIds, const TString& userDataTablePath) {
    return DescribeCryptaIds(ydbClient, cryptaIds, 0, cryptaIds.size(), userDataTablePath);
}

NYdb::NTable::TAsyncDataQueryResult NDescriber::GetCryptaIdsForIds(TYdbClient& ydbClient, const TVector<TIdWithHash>& ids, size_t startIndex, size_t endIndex, const TString& idToCryptaIdTablePath) {
    return ExecuteYdbDynamicQuery<TGetCryptaIdsForIdsDbRequest>(ydbClient, "", {.IdToCryptaIdTablePath = idToCryptaIdTablePath, .Ids = ids, .StartIndex = startIndex, .EndIndex = endIndex}, NYdb::NTable::TTxSettings::StaleRO());
}

NYdb::NTable::TAsyncDataQueryResult NDescriber::GetCryptaIdsForUsers(TYdbClient& ydbClient, TUserSetId userSetId, TUserId lastUserId, ui64 batchSize, const TString& idToCryptaIdTablePath)  {
    return ExecuteYdbDynamicQuery<TGetCryptaIdsForUsersDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.IdToCryptaIdTablePath = idToCryptaIdTablePath, .LastUserId = lastUserId, .BatchSize = batchSize}, NYdb::NTable::TTxSettings::StaleRO());
}

NYdb::NTable::TAsyncDataQueryResult NDescriber::DeleteStats(TYdbClient& ydbClient, ui64 setId) {
    return ExecuteYdbDynamicQuery<TDeleteStatsDbRequest>(ydbClient, "", {.SetId = setId});
}
