from crypta.siberia.bin.common.data.proto import user_set_status_pb2
from crypta.siberia.bin.common.ydb.paths.proto import ydb_paths_pb2

import ydb


def get_expired_user_sets(ydb_client, current_time, last_user_set_id):
    result_sets = ydb_client.create_session().transaction(ydb.SerializableReadWrite()).execute(
        """
        SELECT
            user_sets.id AS id,
            user_sets.type AS type,
            user_sets.status AS status
        FROM {user_sets_table}
        WHERE user_sets.expiration_time < {current_time}
        AND user_sets.id > {last_user_set_id}
        AND user_sets.status != "{status}"
        ORDER BY id;
        """.format(
            current_time=current_time,
            last_user_set_id=last_user_set_id,
            status=user_set_status_pb2.TUserSetStatus().MetaDataOnly,
            user_sets_table=ydb_paths_pb2.TYdbPaths().UserSetsTable,
        ),
        commit_tx=True,
    )
    return result_sets[0].rows
