#include "make_crypta_id_user_data_job.h"

#include "make_crypta_id_user_data_reducer.h"
#include "match_user_data_query.h"

#include <crypta/lib/native/yql/query_executer/query_executer.h>
#include <crypta/lib/native/yt/utils/helpers.h>
#include <crypta/siberia/bin/common/yt_schemas/cpp/schemas.h>

#include <mapreduce/yt/common/config.h>
#include <mapreduce/yt/interface/common.h>
#include <mapreduce/yt/util/temp_table.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia::NCryptaIdUserData;

TMakeCryptaIdUserDataJob::TMakeCryptaIdUserDataJob(TConfig config, NLog::TLogPtr log)
    : Config(std::move(config))
    , Log(log)
{
    Y_ENSURE(Log != nullptr, "Invalid log ptr");
}

int TMakeCryptaIdUserDataJob::Do() {
    Log->info("================ Start ================");

    const auto& ytProxy = Config.GetYtProxy();
    const auto& ytPool = Config.GetYtPool();

    auto client = NYT::CreateClient(ytProxy);
    NYT::TConfig::Get()->Pool = ytPool;

    const auto& dstTablePath = Config.GetDstTable();

    Log->info("Dst table: {}", dstTablePath);

    NYqlUtils::TQueryExecuter executer(ytProxy, ytPool);
    auto tx = client->StartTransaction();

    {
        NYT::TTempTable matchedUserDataTable(tx, "matched_user_data");

        MatchUserData(executer, tx, matchedUserDataTable.Name(), Config.GetYandexuidUserDataTable(), Config.GetYandexuidToCryptaIdTable(), Log);

        tx->Reduce(new TMakeCryptaIdUserDataReducer(Config.GetMaxTokensCount(), Config.GetMinSampleRatio()),
                   matchedUserDataTable.Name(),
                   NYT::TRichYPath(dstTablePath).Schema(GetCryptaIdUserDataStatsSchema()).OptimizeFor(NYT::OF_SCAN_ATTR),
                   {NFields::CRYPTA_ID}
        );
    }
    tx->Commit();

    Log->info("================ Finish ================");
    return 0;
}
