#pragma once

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NSiberia::NCryptaIdUserData {
    class TMakeCryptaIdUserDataReducer : public NYT::IReducer<NYT::TNodeReader, NYT::TNodeWriter> {
    public:
        TMakeCryptaIdUserDataReducer() = default;
        TMakeCryptaIdUserDataReducer(int maxTokensCount, double minSampleRatio);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(MaxTokensCount, MinSampleRatio);

    private:
        int MaxTokensCount = 0;
        double MinSampleRatio = 0;
    };
}
