#include "match_user_data_query.h"

#include <util/string/subst.h>

using namespace NCrypta::NSiberia;

void NCryptaIdUserData::MatchUserData(NYqlUtils::TQueryExecuter& executer, const NYT::ITransactionPtr tx, const TString& dstTable, const TString& yandexuidUserDataTable, const TString& yandexuidToCryptaIdTable, NLog::TLogPtr log) {
    TString query = R"(
        INSERT INTO `{dst_table}` WITH TRUNCATE
        SELECT
            user_data.*,
            CAST(yandexuid_to_crypta_id.target_id AS Uint64) as crypta_id
        FROM `{user_data_table}` view raw as user_data
        JOIN `{yandexuid_to_crypta_id_table}` as yandexuid_to_crypta_id
        ON user_data.yuid == yandexuid_to_crypta_id.id
        ORDER BY crypta_id
    )";

    SubstGlobal(query, "{dst_table}", dstTable);
    SubstGlobal(query, "{user_data_table}", yandexuidUserDataTable);
    SubstGlobal(query, "{yandexuid_to_crypta_id_table}", yandexuidToCryptaIdTable);

    log->info(query);

    executer.Execute(query, NYqlUtils::TQueryOptions().Title("Match user data (YQL)").Tx(tx));
}