import datetime

import yt.wrapper as yt

from crypta.lib.python import time_utils
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.siberia.bin.make_id_to_crypta_id.lib.maker import schema


def make_id_to_crypta_id_table(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    yt_client.create("map_node", config.Yt.TmpDir, recursive=True, ignore_existing=True)

    with yt_client.Transaction() as tx, yt.TempTable(config.Yt.TmpDir, client=yt_client) as tmp_output_table:
        query_params = {
            "dst_table": tmp_output_table,
            "direct_client_id_to_puid_table": config.DirectClientIdToPuidTable,
            "puid_to_crypta_id_table": config.PuidToCryptaIdTable,
            "matching_tables": config.MatchingTables,
            "crypta_id_user_data_table": config.CryptaIdUserDataTable,
            "min_date": (datetime.date.fromtimestamp(time_utils.get_current_time()) - datetime.timedelta(days=config.MatchPeriodInDays)).strftime("%Y-%m-%d"),
            "direct_client_id_type": config.DirectClientIdType,
        }

        yql_helpers.run_query("/query/make_id_to_crypta_id.yql", config.Yt, query_params, logger, tx=tx)

        yt_client.create("table", config.OutputTable, recursive=True, force=True, attributes={"schema": schema.get_id_to_crypta_id_schema()})
        yt_client.run_merge(tmp_output_table, config.OutputTable, mode="sorted", spec={"force_transform": True, "combine_chunks": True, "merge_by": schema.KEY_COLUMNS})
